/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.app.print;

import DE.siemens.ad.logo.dialog.comp.display.DefaultDisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayElement;
import DE.siemens.ad.logo.dialog.comp.display.DisplayModel;
import DE.siemens.ad.logo.dialog.comp.display.LogoDisplay;
import DE.siemens.ad.logo.dialog.comp.display.MessageParameterDisplayModelRTF;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CommentManager;
import DE.siemens.ad.logo.model.MessageParameter;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.print.LogoPrintable;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JDialog;

public class ParameterPagePrinter
extends LogoPrintable
implements Printable {
    protected int fCurrentIndex = 0;
    Block[] fBlocksArr;
    int[] fIndexArr;
    int fParameterPages = -1;
    protected LogoDrawingView fLogoDrawingView;
    public Vector fBlocksToPrint;
    private static final double screenScale = (double)0.8f;
    private final int lineDiff = 15;
    private final int xPosBlock = 20;
    private final int xPosParameter = 350;

    public ParameterPagePrinter(LogoDrawing logoDrawing, Vector blocksToPrint) {
        super(logoDrawing);
        this.fBlocksToPrint = blocksToPrint;
        this.fCurrentIndex = 0;
        this.fParameterPages = -1;
    }

    protected void fillBlocksArray() {
        this.fBlocksArr = null;
        if (0 < this.fBlocksToPrint.size()) {
            this.fBlocksArr = new Block[this.fBlocksToPrint.size()];
            this.fBlocksToPrint.copyInto(this.fBlocksArr);
            this.fIndexArr = new int[this.fBlocksToPrint.size() + 1];
        }
        if (null != this.fBlocksArr) {
            Block.sortForBlockNumber(this.fBlocksArr);
        }
    }

    public void fillIndexArray(Graphics g, PageFormat pf) throws PrinterException {
        this.fParameterPages = 0;
        this.fCurrentIndex = 0;
        this.fillBlocksArray();
        if (null != this.fBlocksArr) {
            while (this.fCurrentIndex < this.fBlocksArr.length) {
                this.fIndexArr[this.fParameterPages] = this.fCurrentIndex;
                this.fCurrentIndex = this.printParameterPage(g, pf, this.fCurrentIndex);
                ++this.fParameterPages;
            }
            this.fIndexArr[this.fParameterPages] = -1;
        }
    }

    public int getPageCount(PageFormat pf, Graphics g) {
        try {
            this.fillIndexArray(g, pf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.fParameterPages;
    }

    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        pi -= this.fFirstPageNumber;
        if (this.fIndexArr == null) {
            this.fillIndexArray(g, pf);
        }
        if (pi >= this.fParameterPages) {
            return 1;
        }
        this.fCurrentIndex = this.fIndexArr[pi];
        g.setColor(Color.black);
        this.translate(g, pf, true);
        Dimension printArea = this.printFooter(g, pf, pi + this.fFirstPageNumber + 1, this.getTotalPage());
        Rectangle preClip = g.getClipBounds();
        Rectangle curClip = new Rectangle(1, 1, printArea.width, printArea.height);
        Rectangle newClip = preClip.intersection(curClip);
        if (!newClip.isEmpty()) {
            this.setClip(g, newClip, pf, false);
            if (null != this.fBlocksArr) {
                this.fCurrentIndex = this.printParameterPage(g, pf, this.fCurrentIndex);
            }
            this.setClip(g, preClip, pf, false);
        }
        this.translate(g, pf, false);
        return 0;
    }

    protected int printParameterPage(Graphics g, PageFormat pf, int startIndex) {
        Dimension printArea = this.printFooter(g, pf, 0, 0);
        return this.printParameters(g, this.fBlocksArr, startIndex, printArea);
    }

    protected int printParameters(Graphics pg, Block[] blocks, int index, Dimension usableDimension) {
        int yPos = 15;
        int verLineStart = 0;
        int currentIndex = index;
        Font ft = new Font("Dialog", 1, 8);
        pg.setFont(ft);
        FontMetrics metrics = pg.getFontMetrics();
        int textHeight = metrics.getHeight();
        pg.drawString(Language.getString("print.blocknumber", "Blocknumber(Type)"), 20, yPos);
        pg.drawString(Language.getString("print.parameter", "Parameter"), 350, yPos);
        pg.drawLine(0, yPos + 15, usableDimension.width, yPos + 15);
        pg.drawLine(0, yPos + 15 + 1, usableDimension.width, yPos + 15 + 1);
        yPos += 30;
        ft = new Font("monospaced", 0, 8);
        pg.setFont(ft);
        metrics = pg.getFontMetrics();
        textHeight = metrics.getHeight();
        while (blocks.length > currentIndex) {
            Object[] desp;
            LogoDisplay[] disps;
            if (null == blocks[currentIndex].getParameter()) {
                ++currentIndex;
                continue;
            }
            String parameterString = blocks[currentIndex].getParameter().getParameterText();
            StringTokenizer tokenizer = new StringTokenizer(parameterString, "\n");
            CommentManager cManager = this.fDrawing.getCommentManager();
            String comment = cManager.getCommentParameter(blocks[currentIndex]).getText();
            Vector subStringVector = null;
            if (comment != null && comment.length() > 0) {
                subStringVector = Util.createSubStrings(comment, metrics, 315);
            }
            if (!this.checkSpaceAndPrepare(textHeight, usableDimension.height - yPos, blocks[currentIndex], tokenizer, subStringVector, disps = new LogoDisplay[2], desp = new Object[2])) {
                if (currentIndex != index) break;
                System.err.println("Only partly comments will be printed for " + blocks[currentIndex]);
            }
            String blockName = blocks[currentIndex].getNumberString();
            blockName = blockName + "(";
            blockName = blockName + Language.getString(blocks[currentIndex].getLanguageKey(), blocks[currentIndex].getName());
            blockName = blockName + ") : ";
            pg.drawString(blockName, 20, yPos);
            int commentYPos = yPos + textHeight;
            if (subStringVector != null) {
                for (int i = 0; i < subStringVector.size(); ++i) {
                    pg.drawString((String)subStringVector.elementAt(i), 20, commentYPos);
                    commentYPos += textHeight;
                }
            }
            int paramYPos = yPos;
            while (tokenizer.hasMoreTokens()) {
                pg.drawString(tokenizer.nextToken(), 350, paramYPos);
                paramYPos += textHeight;
            }
            yPos = Math.max(paramYPos, commentYPos);
            boolean screenExisted = false;
            for (int i = 0; i < 2; ++i) {
                if (disps[i] != null) {
                    this.drawDisplay(disps[i], pg, 20, yPos);
                    screenExisted = true;
                    MessageParameter param = (MessageParameter)blocks[currentIndex].getParameter();
                    Vector settingStrings = this.getMessageSettings(param, i);
                    int yPosSet = yPos + textHeight / 2;
                    pg.drawString("-->", 330, yPosSet);
                    for (int j = 0; j < settingStrings.size(); ++j) {
                        pg.drawString((String)settingStrings.elementAt(j), 350, yPosSet);
                        yPosSet += textHeight;
                    }
                    yPos += (int)((double)disps[i].getPreferredSize().height * (double)0.8f) + 15;
                }
                if (desp[i] == null) continue;
                Vector despStrings = (Vector)desp[i];
                for (int j = 0; j < despStrings.size(); ++j) {
                    pg.drawString((String)despStrings.elementAt(j), 20, yPos);
                    yPos += textHeight;
                }
            }
            if (screenExisted) {
                pg.drawLine(335, verLineStart, 335, Math.max(paramYPos, commentYPos) - 7);
            } else {
                pg.drawLine(335, verLineStart, 335, Math.max(paramYPos, commentYPos));
            }
            pg.drawLine(0, yPos, usableDimension.width, yPos);
            verLineStart = yPos;
            yPos += 15;
            ++currentIndex;
        }
        return currentIndex;
    }

    private void drawDisplay(LogoDisplay disp, Graphics g, int x, int y) {
        if (g.getClip() == null) {
            return;
        }
        int imageWidth = (int)((double)disp.getPreferredSize().width * (double)0.8f);
        int imageHeight = (int)((double)disp.getPreferredSize().height * (double)0.8f);
        Graphics buffer = g.create(x, y, imageWidth, imageHeight);
        if (buffer.getClipBounds().intersects(new Rectangle(0, 0, imageWidth, imageHeight))) {
            ((Graphics2D)buffer).scale(0.6400000095367432, 0.8f);
            JDialog temp = new JDialog();
            temp.add(disp);
            temp.setLayout(new FlowLayout());
            temp.pack();
            disp.print(buffer);
            temp.dispose();
        }
    }

    private boolean checkSpaceAndPrepare(int textHeight, int leftSpace, Block block, StringTokenizer params, Vector comments, LogoDisplay[] disps, Object[] desp) {
        int parameterHeight = params.countTokens() * textHeight + 15;
        if (parameterHeight > leftSpace) {
            return false;
        }
        int commentHeight = textHeight;
        if (comments != null && (commentHeight = comments.size() * textHeight + 15) > leftSpace) {
            return false;
        }
        if (block.getParameter() instanceof MessageParameter) {
            int msgBlockHeight = Math.max(parameterHeight, commentHeight);
            MessageParameter param = (MessageParameter)block.getParameter();
            for (int i = 0; i < 2; ++i) {
                if (param.getMessageRTF(i) == null) continue;
                MessageParameterDisplayModelRTF displayModel = new MessageParameterDisplayModelRTF(param, i);
                disps[i] = this.getLogoDisplay(displayModel, i);
                if ((msgBlockHeight += (int)((double)disps[i].getPreferredSize().height * (double)0.8f)) > leftSpace) {
                    return false;
                }
                desp[i] = this.getNonTextElements(displayModel);
                if ((msgBlockHeight += ((Vector)desp[i]).size() * textHeight + 15) <= leftSpace) continue;
                return false;
            }
        }
        return true;
    }

    private Vector getNonTextElements(MessageParameterDisplayModelRTF displayModel) {
        Vector<String> ret = new Vector<String>();
        Vector<DisplayElement> elements = new Vector<DisplayElement>();
        for (int y = 0; y < displayModel.getDisplayDimension().height; ++y) {
            int x = 0;
            while (x < displayModel.getDisplayDimension().width) {
                Point currentCell = new Point(x, y);
                DisplayElement value = displayModel.getElementAt(currentCell);
                if (value != null && !(value instanceof DefaultDisplayElement) && !elements.contains(value)) {
                    elements.add(value);
                    ret.add(this.getElementPrintString(value, x, y));
                }
                Rectangle cellBounds = displayModel.getElementBounds(currentCell);
                if (cellBounds.width > 0 && cellBounds.y == currentCell.y) {
                    x = cellBounds.x + cellBounds.width;
                    continue;
                }
                ++x;
            }
        }
        return ret;
    }

    private String getElementPrintString(DisplayElement disp, int x, int y) {
        StringBuffer ret = new StringBuffer();
        ret.append("Line").append(y + 1).append('.').append(x + 1).append(' ');
        ret.append(disp.getContentsString());
        return ret.toString();
    }

    private Vector getMessageSettings(MessageParameter param, int index) {
        Vector<String> ret = new Vector<String>();
        ret.add(Language.getString("dialog.parameter.message.tickerSetting", "ticker?"));
        StringBuffer tmp = new StringBuffer("  - ");
        tmp.append(param.getMessageRTF(index).getTickerTypeString());
        ret.add(tmp.toString());
        for (int i = 0; i < 4; ++i) {
            tmp = new StringBuffer("  - ");
            tmp.append("\tLine").append(i + 1).append(": ").append(param.getMessageRTF(index).getMessageLineRTF()[i].isTickerLine() ? "Y" : "N");
            ret.add(tmp.toString());
        }
        ret.add(Language.getString("dialog.parameter.message.showDestSetting", "Destination?"));
        tmp = new StringBuffer("  - ");
        tmp.append(param.getMessageRTF(index).getDestinationString());
        ret.add(tmp.toString());
        return ret;
    }

    private LogoDisplay getLogoDisplay(DisplayModel displayModel, int charSetID) {
        LogoDisplay disp = new LogoDisplay(){
            private static final long serialVersionUID = 1L;

            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return d;
            }
        };
        disp.setCellRendererMode(LogoDisplay.MODE_DETAIL);
        disp.setModel(displayModel);
        return disp;
    }
}

